/****** Object:  Trigger [TRG_EST_NF_ENT]    Script Date: 01/08/2014 05:08:15 ******/
IF EXISTS(SELECT NAME FROM SYS.TRIGGERS 
			WHERE NAME = 'TRG_EST_NF_ENT')
    BEGIN
        DROP TRIGGER [dbo].[TRG_EST_NF_ENT];
    END;

/****** Object:  Trigger [TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA]    Script Date: 01/08/2014 05:08:15 ******/

IF EXISTS( SELECT NAME FROM SYS.TRIGGERS 
				WHERE NAME = 'TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA')
    BEGIN
        DROP TRIGGER [dbo].[TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA];
    END;
GO

IF NOT EXISTS(SELECT *FROM INFORMATION_SCHEMA.COLUMNS 
				WHERE TABLE_NAME  = 'EST_PROD_CPL_EST_NF_IT_ULTIMA'
						AND COLUMN_NAME ='CD_NF_ICMS_RET')
BEGIN
	ALTER TABLE EST_PROD_CPL_EST_NF_IT_ULTIMA ADD CD_NF_ICMS_RET INT NULL 
END
GO
IF NOT EXISTS(SELECT *FROM INFORMATION_SCHEMA.COLUMNS 
				WHERE TABLE_NAME  = 'EST_PROD_CPL_EST_NF_IT_ULTIMA'
						AND COLUMN_NAME ='PERC_ICMS_RET')
BEGIN
	ALTER TABLE EST_PROD_CPL_EST_NF_IT_ULTIMA ADD PERC_ICMS_RET MONEY NULL  
END
GO

CREATE TRIGGER [dbo].[TRG_EST_PROD_CPL_EST_NF_IT_ULTIMA] ON [dbo].[EST_NF_ENT_IT]
FOR INSERT
AS
------------------------------------------------------------------------------------------------------------------------------
CREATE TABLE #TMP_NFUltima (CD_EMP		INT, 
							CD_FILIAL	INT,	
							CD_PROD		INT, 							
							CD_NF		INT, 
							CD_NF_ICMS_RET	INT null, 
							PERC_ICMS_RET money null)
	
	insert into #TMP_NFUltima(	CD_EMP, CD_FILIAL, CD_PROD,	CD_NF,	CD_NF_ICMS_RET, PERC_ICMS_RET )
	SELECT
		INS.CD_EMP,
		INS.CD_FILIAL,
		INS.CD_PROD,
		INS.CD_NF,
		INS.CD_NF,		
		INS.PERC_ICMS_RET
    FROM 
		INSERTED INS
        INNER JOIN EST_NF_ENT ON INS.CD_EMP = EST_NF_ENT.CD_EMP
                                AND INS.CD_FILIAL = EST_NF_ENT.CD_FILIAL
                                AND INS.CD_NF = EST_NF_ENT.CD_NF
        INNER JOIN GLB_MOV_OP ON EST_NF_ENT.CD_NT_MOV = GLB_MOV_OP.CD_MOV_OP;

------------------------------------------------------------------------------------------------------------------------------
	
	update #TMP_NFUltima set CD_NF_ICMS_RET = null, PERC_ICMS_RET= NULL
		WHERE 
			NOT PERC_ICMS_RET >0 ;

------------------------------------------------------------------------------------------------------------------------------
	--Preserva o codigo do icms_ret da ultima nota fiscal.
	
	update t 
	set
		CD_NF_ICMS_RET = U.CD_NF_ICMS_RET, 
		PERC_ICMS_RET  = U.PERC_ICMS_RET
	from 
		#TMP_NFUltima t
		join EST_PROD_CPL_EST_NF_IT_ULTIMA u on 
		t.CD_EMP	= u.CD_EMP AND 
		t.CD_FILIAL = u.CD_FILIAL AND 
		t.CD_NF		= u.CD_NF AND 
		t.CD_PROD	= u.CD_PROD
	WHERE
		T.CD_NF_ICMS_RET IS NULL

------------------------------------------------------------------------------------------------------------------------------

	--Removendo se caso existir o registro.
	DELETE FROM u
	FROM 
		#TMP_NFUltima t
		join EST_PROD_CPL_EST_NF_IT_ULTIMA u on 
		t.CD_EMP	= u.CD_EMP AND 
		t.CD_FILIAL = u.CD_FILIAL AND 
		t.CD_PROD	= u.CD_PROD;
		 
------------------------------------------------------------------------------------------------------------------------------
	--Inserindo se caso for entrada por compras de mercadorias
	INSERT INTO EST_PROD_CPL_EST_NF_IT_ULTIMA (CD_EMP
												,CD_FILIAL
												,CD_PROD
												,CD_NF
												,CD_NF_ICMS_RET
												,PERC_ICMS_RET)
	SELECT
		cd_emp
		, cd_filial
		, cd_prod
		, cd_nf
		, cd_nf_icms_ret     
		, perc_icms_ret 
	FROM
		#TMP_NFUltima;

------------------------------------------------------------------------------------------------------------------------------

 
------------------------------------------------------------------------------------------------------------------------------